<?php

namespace Modules\Common\Entities\Entities;

use Illuminate\Database\Eloquent\Model;

class EntityAddress extends Model 
{

    protected $table = 'entity_addresses';
    public $timestamps = true;

    public function country()
    {
        return $this->belongsTo('Country', 'country_code', 'code');
    }

    public function person()
    {
        return $this->belongsTo('Entity');
    }

    public function type()
    {
        return $this->belongsTo('AddressType', 'type', 'id');
    }

    public function postalcode()
    {
        return $this->belongsTo('PostalCode', 'postal_code', 'code');
    }

}